<?php
/*--------------------------------------------------------------
   Serial.php 2021-06-02
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Data\Factory;

use Gambio\Admin\Modules\Statistics\Model\Collections\SerialCategories;
use Gambio\Admin\Modules\Statistics\Model\Collections\SerialItems;
use Gambio\Admin\Modules\Statistics\Model\Collections\SerialItemValues;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Serial as SerialData;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Serial\Category as SerialCategory;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Serial\Item as SerialItem;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Serial\Item\Title as SerialItemTitle;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Serial\Item\Value as SerialItemValue;

class Serial
{
    /**
     * Return serial data.
     */
    public function createSerialData(SerialCategories $categories, SerialItems $series): SerialData
    {
        return SerialData::create($categories, $series);
    }
    
    
    /**
     * Return categories.
     */
    public function createCategories(SerialCategory ...$categories): SerialCategories
    {
        return SerialCategories::create(...$categories);
    }
    
    
    /**
     * Return category.
     */
    public function createCategory(string $category): SerialCategory
    {
        return SerialCategory::create($category);
    }
    
    
    /**
     * Return items.
     */
    public function createItems(SerialItem ...$items): SerialItems
    {
        return SerialItems::create(...$items);
    }
    
    
    /**
     * Return item.
     */
    public function createItem(SerialItemTitle $title, SerialItemValues $values): SerialItem
    {
        return SerialItem::create($title, $values);
    }
    
    
    /**
     * Return item title.
     */
    public function createItemTitle(string $title): SerialItemTitle
    {
        return SerialItemTitle::create($title);
    }
    
    
    /**
     * Return item values.
     */
    public function createItemValues(SerialItemValue ...$values): SerialItemValues
    {
        return SerialItemValues::create(...$values);
    }
    
    
    /**
     * Return item value.
     */
    public function createItemValue(float $value): SerialItemValue
    {
        return SerialItemValue::create($value);
    }
}